//
//  GeometryGamesNSFView.swift
//
//  Created by Jeff on 21/12/20.
//  Copyright © 2020 Jeff Weeks. All rights reserved.
//

import SwiftUI


struct GeometryGamesHelpMenuNSFItemLabel: View {

	var body: some View {

		Label(
			title: {
				Text(verbatim: "NSF")
			},
			icon: {
				Image(systemName: "atom")
			}
		)
	}
}


struct GeometryGamesNSFView: View {

	var body: some View {
	
		VStack() {
		
			VStack() {
				Text("Thanks to the")
					.font(.system(.body, design: Font.Design.serif))
					.italic()

				//	SwiftUI happily lets .body size text wrap to multiple lines,
				//	but seems to limit title<n> size text to one line only.
				VStack() {
					Text("U.S. National")
					Text("Science Foundation")
				}
				.font(.title2)
				.padding(EdgeInsets(top: 0.1, leading: 0, bottom: 0.1, trailing: 0))
					//	even tiny insets have a significant effect

				Text("for partial funding")
					.font(.system(.body, design: Font.Design.serif))
					.italic()
			}
			.foregroundColor(Color.init(.displayP3, red: 0.0, green: 0.0, blue: 1.0, opacity: 1.0))
			.padding(EdgeInsets(top: 0, leading: 0, bottom: 16, trailing: 0))

			Text(
				"""
				This material is based upon work partially
				supported by the National Science
				Foundation under Grant No. 1503701.
				Any opinions, findings, and conclusions
				or recommendations expressed in this
				material are those of the author and
				do not necessarily reflect the views
				of the National Science Foundation.
				"""
			)
			.font(.caption2)
		}
		.multilineTextAlignment(.center)
		.padding(geometryGamesPanelPadding)
		.background(Color(.displayP3, red: 1.0, green: 0.875, blue: 0.75, opacity: 1.0))
		.cornerRadius(geometryGamesCornerRadius)
	}
}
